/*
	File:		Offscreen.cp

	Contains:	Class to help with offscreen drawing.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#include "Offscreen.h"
#include "ColorPenState.h"

Offscreen::Offscreen()
{
	fWorld = nil;
	fSavePort = nil;
	fSaveDevice = nil;
	SetRect( &fBounds, 0, 0, 0, 0 );
}

Offscreen::~Offscreen()
{
}

void
Offscreen::StartDrawing( const Rect& bounds, Boolean copyDest )
{
	QDErr			err;
	Rect			globalRect;
	ColorPenState	state;
	
	fBounds = bounds;
	
	GetGWorld( &fSavePort, &fSaveDevice );
	
	globalRect = fBounds;
	
	LocalToGlobal( &topLeft( globalRect ) );
	LocalToGlobal( &botRight( globalRect ) );

	err = NewGWorld( &fWorld, 0, &globalRect, nil, nil, 0 );
	if ( err == noErr )
	{
		GetColorAndPenState( &state );
		SetGWorld( fWorld, nil );
		SetOrigin( fBounds.left, fBounds.top );
		SetColorAndPenState( &state );
		
		LockPixels( GetGWorldPixMap( fWorld ) );
		EraseRect( &fBounds );
		TextFont( fSavePort->txFont );
		TextSize( fSavePort->txSize );
		TextFace( fSavePort->txFace );
		TextMode( fSavePort->txMode );
		
		if ( copyDest )
		{
			CopyBits( (BitMap*)*fSavePort->portPixMap, (BitMap*)*fWorld->portPixMap,
				&fBounds, &fWorld->portRect, srcCopy, nil );
		}
	}
	else
		fWorld = nil; // make sure
}

void
Offscreen::EndDrawing()
{
	ColorPenState	state;
	
	if ( fWorld == nil ) return;
	
	SetOrigin( 0, 0 );
	SetGWorld( fSavePort, fSaveDevice );

	GetColorAndPenState( &state );
	NormalizeColorAndPen();
	
	CopyBits( (BitMap*)&fWorld->portPixMap, (BitMap*)&fSavePort->portPixMap,
			&fWorld->portRect, &fBounds, srcCopy, NULL );

	UnlockPixels( GetGWorldPixMap( fWorld ) );
	DisposeGWorld( fWorld );
	
	fWorld = nil;
	
	SetColorAndPenState( &state );
}

void
Offscreen::EndDrawingAndBlend( const RGBColor& opColor )
{
	ColorPenState	state;
	
	if ( fWorld == nil ) return;
	
	SetOrigin( 0, 0 );
	SetGWorld( fSavePort, fSaveDevice );

	GetColorAndPenState( &state );
	NormalizeColorAndPen();
	
	OpColor( &opColor );
	CopyBits( (BitMap*)&fWorld->portPixMap, (BitMap*)&fSavePort->portPixMap,
			&fWorld->portRect, &fBounds, blend, NULL );

	UnlockPixels( GetGWorldPixMap( fWorld ) );
	DisposeGWorld( fWorld );
	
	fWorld = nil;
	
	SetColorAndPenState( &state );
}

